package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 明细开票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-10
 */
public enum InvoiceDetailType {

    ITEM_CATEGORY("itemCategory", "按税编类别开具"),
    ITEM_DETAIL("itemDetail", "按商品名称开具");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceDetailType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceDetailType fromCode(String code){
        switch(code) {
            case "itemCategory":
                return ITEM_CATEGORY;
            case "itemDetail":
                return ITEM_DETAIL;
            default:
                return null;
        }
    }
}
