package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * channel_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-29
 */
public enum ChannelType {

    ALI("ali", "阿里"),
    PDP("pdp", "商联"),
    COMMON("common", "通用"),
    YOUZAN("youzan", "有赞"),
    RPA("rpa", "RPA"),
    MEITUAN("meituan", "美团"),
    ELEME("eleme", "饿了么");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChannelType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChannelType fromCode(String code){
        switch(code) {
            case "ali":
                return ALI;
            case "pdp":
                return PDP;
            case "common":
                return COMMON;
            case "youzan":
                return YOUZAN;
            case "rpa":
                return RPA;
            case "meituan":
                return MEITUAN;
            case "eleme":
                return ELEME;
            default:
                return null;
        }
    }
}
