package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * request_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-29
 */
public enum RequestType {

    API("API", "API"),
    MESSAGE("MESSAGE", "消息");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RequestType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RequestType fromCode(String code){
        switch(code) {
            case "API":
                return API;
            case "MESSAGE":
                return MESSAGE;
            default:
                return null;
        }
    }
}
