package com.xforceplus.ultraman.app.aliqianniu.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 用户授权
 * </p>
 *
 * @author ultraman
 * @since 2024-12-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserAuth implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 淘宝账号名
   */
  private String taobaoUserNick;

  /**
   * 淘宝帐号对应id
   */
  private String taobaoUserId;

  /**
   * accessToken
   */
  private String accessToken;

  /**
   * 到期时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expireTime;

  /**
   * 有效期（秒）
   */
  private Long expiresIn;

  /**
   * Refresh token
   */
  private String refreshToken;

  /**
   * refreshToken有效期（秒）
   */
  private Long reExpiresIn;

  /**
   * r1级别API或字段的访问过期时间
   */
  private Long r1ExpiresIn;

  /**
   * r2级别API或字段的访问过期时间
   */
  private Long r2ExpiresIn;

  /**
   * w1级别API或字段的访问过期时间
   */
  private Long w1ExpiresIn;

  /**
   * w2级别API或字段的访问过期时间
   */
  private Long w2ExpiresIn;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 授权code
   */
  private String code;

  /**
   * erp渠道
   */
  private String ecErpChannel;

  /**
   * 总店id
   */
  private String mainStoreId;

  /**
   * 授权到期时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authExpireTime;

  /**
   * 授权状态
   */
  private String authStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("taobao_user_nick", taobaoUserNick);
      map.put("taobao_user_id", taobaoUserId);
      map.put("access_token", accessToken);
      map.put("expire_time", BocpGenUtils.toTimestamp(expireTime));
      map.put("expires_in", expiresIn);
      map.put("refresh_token", refreshToken);
      map.put("re_expires_in", reExpiresIn);
      map.put("r1_expires_in", r1ExpiresIn);
      map.put("r2_expires_in", r2ExpiresIn);
      map.put("w1_expires_in", w1ExpiresIn);
      map.put("w2_expires_in", w2ExpiresIn);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("code", code);
      map.put("ec_erp_channel", ecErpChannel);
      map.put("main_store_id", mainStoreId);
      map.put("auth_expire_time", BocpGenUtils.toTimestamp(authExpireTime));
      map.put("auth_status", authStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static UserAuth fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    UserAuth entity = new UserAuth();
    if(map.containsKey("taobao_user_nick")) {
      Object obj = map.get("taobao_user_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaobaoUserNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taobao_user_id")) {
      Object obj = map.get("taobao_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaobaoUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("access_token")) {
      Object obj = map.get("access_token");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccessToken((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expire_time")) {
      Object obj = map.get("expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpireTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpireTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpireTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpireTime(null);
      }
    }
    if(map.containsKey("expires_in")) {
      Object obj = map.get("expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("refresh_token")) {
      Object obj = map.get("refresh_token");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefreshToken((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("re_expires_in")) {
      Object obj = map.get("re_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("r1_expires_in")) {
      Object obj = map.get("r1_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setR1ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setR1ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setR1ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("r2_expires_in")) {
      Object obj = map.get("r2_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setR2ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setR2ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setR2ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("w1_expires_in")) {
      Object obj = map.get("w1_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setW1ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setW1ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setW1ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("w2_expires_in")) {
      Object obj = map.get("w2_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setW2ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setW2ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setW2ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("main_store_id")) {
      Object obj = map.get("main_store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_expire_time")) {
      Object obj = map.get("auth_expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthExpireTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthExpireTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthExpireTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthExpireTime(null);
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("taobao_user_nick")) {
      Object obj = map.get("taobao_user_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaobaoUserNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taobao_user_id")) {
      Object obj = map.get("taobao_user_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaobaoUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("access_token")) {
      Object obj = map.get("access_token");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccessToken((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expire_time")) {
      Object obj = map.get("expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpireTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpireTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpireTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpireTime(null);
      }
    }
    if(map.containsKey("expires_in")) {
      Object obj = map.get("expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("refresh_token")) {
      Object obj = map.get("refresh_token");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefreshToken((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("re_expires_in")) {
      Object obj = map.get("re_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("r1_expires_in")) {
      Object obj = map.get("r1_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setR1ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setR1ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setR1ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("r2_expires_in")) {
      Object obj = map.get("r2_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setR2ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setR2ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setR2ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("w1_expires_in")) {
      Object obj = map.get("w1_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setW1ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setW1ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setW1ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("w2_expires_in")) {
      Object obj = map.get("w2_expires_in");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setW2ExpiresIn((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setW2ExpiresIn(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setW2ExpiresIn(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcErpChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("main_store_id")) {
      Object obj = map.get("main_store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_expire_time")) {
      Object obj = map.get("auth_expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthExpireTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthExpireTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthExpireTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthExpireTime(null);
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
