package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rpa_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-28
 */
public enum RpaStatus {

    _0("0", "停用"),
    _1("1", "正常"),
    _2("2", "断开");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RpaStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
