package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * trigger_status
 * </p>
 *
 * @author ultraman
 * @since 2025-04-22
 */
public enum TriggerStatus {

    BUYER_PAYED("buyer_payed", "买家已付款"),
    SENT_GOODS("sent_goods", "卖家已发货"),
    BUYER_CONFIRM("buyer_confirm", "买家确认收货"),
    REFUND_SELLER_CONFIRM("refund_seller_confirm", "卖家同意退款"),
    INVOICE_SUPPLY("invoice_supply", "买家申请补开发票"),
    INVOICE_CHANGE("invoice_change", "买家申请改抬头"),
    CHANGE_PAPER("change_paper", "电换纸"),
    BUYER_CANCEL("buyer_cancel", "买家取消申请");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TriggerStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TriggerStatus fromCode(String code){
        switch(code) {
            case "buyer_payed":
                return BUYER_PAYED;
            case "sent_goods":
                return SENT_GOODS;
            case "buyer_confirm":
                return BUYER_CONFIRM;
            case "refund_seller_confirm":
                return REFUND_SELLER_CONFIRM;
            case "invoice_supply":
                return INVOICE_SUPPLY;
            case "invoice_change":
                return INVOICE_CHANGE;
            case "change_paper":
                return CHANGE_PAPER;
            case "buyer_cancel":
                return BUYER_CANCEL;
            default:
                return null;
        }
    }
}
