package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_timeout_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-16
 */
public enum InvoiceTimeoutStatus {

    _0("0", "未超期"),
    _5("5", "已超期"),
    _9("9", "即将超期"),
    _2("2", "已完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTimeoutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTimeoutStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "5":
                return _5;
            case "9":
                return _9;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
