package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_error_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum ApplyErrorCode {

    _999("999", "通用错误"),
    _510("510", "服务已到期或用量不足");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyErrorCode fromCode(String code){
        switch(code) {
            case "999":
                return _999;
            case "510":
                return _510;
            default:
                return null;
        }
    }
}
