package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum EcCode {

    ALI("ALI", "阿里千牛"),
    PDD("PDD", "拼多多"),
    YUXIAOER("YUXIAOER", "寓小二"),
    YOUZAN("YOUZAN", "有赞"),
    DOUYIN("DOUYIN", "抖音"),
    JD("JD", "京东"),
    XHS("XHS", "小红书"),
    COMMON("COMMON", "通用"),
    MEITUAN("MEITUAN", "美团"),
    ELEME("ELEME", "饿了么"),
    TMYP("TMYP", "天猫优品"),
    QMAI("QMAI", "企迈");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EcCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcCode fromCode(String code){
        switch(code) {
            case "ALI":
                return ALI;
            case "PDD":
                return PDD;
            case "YUXIAOER":
                return YUXIAOER;
            case "YOUZAN":
                return YOUZAN;
            case "DOUYIN":
                return DOUYIN;
            case "JD":
                return JD;
            case "XHS":
                return XHS;
            case "COMMON":
                return COMMON;
            case "MEITUAN":
                return MEITUAN;
            case "ELEME":
                return ELEME;
            case "TMYP":
                return TMYP;
            case "QMAI":
                return QMAI;
            default:
                return null;
        }
    }
}
