package com.xforceplus.ultraman.app.aliqianniu.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 商户支付订单
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderPaid implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 活动代码
   */
  private String activityCode;

  /**
   * 应用收费代码
   */
  private String articleCode;

  /**
   * 应用名称
   */
  private String articleName;

  /**
   * 订单类型
   */
  private String bizType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订单创建时间（订购时间）
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime create;

  /**
   * 收费项目代码
   */
  private String itemCode;

  /**
   * 收费项目名称
   */
  private String itemName;

  /**
   * 用户账号
   */
  private String nick;

  /**
   * 订购周期
   */
  private String orderCycle;

  /**
   * 订购周期开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderCycleStart;

  /**
   * 订购周期结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderCycleEnd;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 外部交易号
   */
  private String outerTradeCode;

  /**
   * 付款状态
   */
  private String payStatus;

  /**
   * 收费项目的版本序号
   */
  private Long versionNo;

  /**
   * 订单号
   */
  private String bizOrderId;

  /**
   * 子订单号
   */
  private String orderId;

  /**
   * 计费记录id
   */
  private Long billRecordId;

  /**
   * 原价（单位为分）
   */
  private BigDecimal fee;

  /**
   * 优惠（单位为分）
   */
  private BigDecimal promFee;

  /**
   * 退款（单位为分）
   */
  private BigDecimal refundFee;

  /**
   * 实付（单位为分）
   */
  private BigDecimal totalPayFee;

  /**
   * erp渠道
   */
  private String ecErpChannel;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("activity_code", activityCode);
      map.put("article_code", articleCode);
      map.put("article_name", articleName);
      map.put("biz_type", bizType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("create", BocpGenUtils.toTimestamp(create));
      map.put("item_code", itemCode);
      map.put("item_name", itemName);
      map.put("nick", nick);
      map.put("order_cycle", orderCycle);
      map.put("order_cycle_start", BocpGenUtils.toTimestamp(orderCycleStart));
      map.put("order_cycle_end", BocpGenUtils.toTimestamp(orderCycleEnd));
      map.put("order_status", orderStatus);
      map.put("outer_trade_code", outerTradeCode);
      map.put("pay_status", payStatus);
      map.put("version_no", versionNo);
      map.put("biz_order_id", bizOrderId);
      map.put("order_id", orderId);
      map.put("bill_record_id", billRecordId);
      map.put("fee", fee);
      map.put("prom_fee", promFee);
      map.put("refund_fee", refundFee);
      map.put("total_pay_fee", totalPayFee);
      map.put("ec_erp_channel", ecErpChannel);
      map.put("org_tree", orgTree);

      return map;
  }

  public static OrderPaid fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderPaid entity = new OrderPaid();
    if(map.containsKey("activity_code")) {
      Object obj = map.get("activity_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActivityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("article_code")) {
      Object obj = map.get("article_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArticleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("article_name")) {
      Object obj = map.get("article_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArticleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create")) {
      Object obj = map.get("create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreate(null);
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nick")) {
      Object obj = map.get("nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_cycle")) {
      Object obj = map.get("order_cycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_cycle_start")) {
      Object obj = map.get("order_cycle_start");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderCycleStart(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderCycleStart((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderCycleStart(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderCycleStart(null);
      }
    }
    if(map.containsKey("order_cycle_end")) {
      Object obj = map.get("order_cycle_end");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderCycleEnd(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderCycleEnd((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderCycleEnd(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderCycleEnd(null);
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outer_trade_code")) {
      Object obj = map.get("outer_trade_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterTradeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version_no")) {
      Object obj = map.get("version_no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersionNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVersionNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVersionNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_record_id")) {
      Object obj = map.get("bill_record_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillRecordId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillRecordId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillRecordId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fee")) {
      Object obj = map.get("fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prom_fee")) {
      Object obj = map.get("prom_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_fee")) {
      Object obj = map.get("refund_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_pay_fee")) {
      Object obj = map.get("total_pay_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPayFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPayFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPayFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPayFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPayFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("activity_code")) {
      Object obj = map.get("activity_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("article_code")) {
      Object obj = map.get("article_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArticleCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("article_name")) {
      Object obj = map.get("article_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArticleName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create")) {
      Object obj = map.get("create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreate(null);
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nick")) {
      Object obj = map.get("nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_cycle")) {
      Object obj = map.get("order_cycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_cycle_start")) {
      Object obj = map.get("order_cycle_start");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderCycleStart(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderCycleStart((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderCycleStart(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderCycleStart(null);
      }
    }
    if(map.containsKey("order_cycle_end")) {
      Object obj = map.get("order_cycle_end");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderCycleEnd(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderCycleEnd((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderCycleEnd(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderCycleEnd(null);
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outer_trade_code")) {
      Object obj = map.get("outer_trade_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterTradeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("version_no")) {
      Object obj = map.get("version_no");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVersionNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVersionNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVersionNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_record_id")) {
      Object obj = map.get("bill_record_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillRecordId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillRecordId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillRecordId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("fee")) {
      Object obj = map.get("fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("prom_fee")) {
      Object obj = map.get("prom_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("refund_fee")) {
      Object obj = map.get("refund_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_pay_fee")) {
      Object obj = map.get("total_pay_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalPayFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalPayFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalPayFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalPayFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalPayFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcErpChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
