package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * store_tax_status
 * </p>
 *
 * @author ultraman
 * @since 2025-11-05
 */
public enum StoreTaxStatus {

    _1("1", "正常"),
    _0("0", "未完成"),
    _4("4", "停用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StoreTaxStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreTaxStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
