package com.xforceplus.ultraman.app.aliqianniu.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 开票申请
 * </p>
 *
 * @author ultraman
 * @since 2025-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceApply implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 抬头类型
   */
  private String businessType;

  /**
   * 电商平台代码
   */
  private String platformCode;

  /**
   * 卖家Nick
   */
  private String sellerNick;

  /**
   * 开票申请触发类型
   */
  private String triggerStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票申请ID
   */
  private String applyId;

  /**
   * 订单号
   */
  private String platformTid;

  /**
   * 申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 是否debug
   */
  private Boolean isDebug;

  /**
   * 开票申请状态
   */
  private String applyStatus;

  /**
   * 申请信息
   */
  private String applyMsg;

  /**
   * erp渠道
   */
  private String ecErpChannel;

  /**
   * 电商代码
   */
  private String ecCode;

  /**
   * 采集账号
   */
  private String loginId;

  /**
   * 重试次数
   */
  private Long retryCount;

  /**
   * 错误码
   */
  private String errorCode;

  /**
   * 开票到期状态
   */
  private String invoiceTimeoutStatus;

  /**
   * 开票到期时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTimeoutTime;

  /**
   * 请求流水号
   */
  private String requestSerialNo;

  /**
   * 原始请求报文
   */
  private String originalRequestUrl;

  /**
   * 三方平台订单号
   */
  private String thirdPartyPlatformNo;

  /**
   * 回写状态
   */
  private String callBackStatus;

  /**
   * 回写消息
   */
  private String callBackMessage;

  /**
   * 回写时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime callBackTime;

  /**
   * 客户请求流水号
   */
  private String customerRequestSerialNo;

  /**
   * 订单状态
   */
  private String billStatus;

  /**
   * 店铺品牌
   */
  @TableField("brandCode")
  private String brandCode;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_type", businessType);
      map.put("platform_code", platformCode);
      map.put("seller_nick", sellerNick);
      map.put("trigger_status", triggerStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("apply_id", applyId);
      map.put("platform_tid", platformTid);
      map.put("apply_time", BocpGenUtils.toTimestamp(applyTime));
      map.put("is_debug", isDebug);
      map.put("apply_status", applyStatus);
      map.put("apply_msg", applyMsg);
      map.put("ec_erp_channel", ecErpChannel);
      map.put("ec_code", ecCode);
      map.put("login_id", loginId);
      map.put("retry_count", retryCount);
      map.put("error_code", errorCode);
      map.put("invoice_timeout_status", invoiceTimeoutStatus);
      map.put("invoice_timeout_time", BocpGenUtils.toTimestamp(invoiceTimeoutTime));
      map.put("request_serial_no", requestSerialNo);
      map.put("original_request_url", originalRequestUrl);
      map.put("third_party_platform_no", thirdPartyPlatformNo);
      map.put("call_back_status", callBackStatus);
      map.put("call_back_message", callBackMessage);
      map.put("call_back_time", BocpGenUtils.toTimestamp(callBackTime));
      map.put("customer_request_serial_no", customerRequestSerialNo);
      map.put("bill_status", billStatus);
      map.put("brandCode", brandCode);
      map.put("org_tree", orgTree);

      return map;
  }

  public static InvoiceApply fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceApply entity = new InvoiceApply();
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_code")) {
      Object obj = map.get("platform_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatformCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trigger_status")) {
      Object obj = map.get("trigger_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTriggerStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_tid")) {
      Object obj = map.get("platform_tid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatformTid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("is_debug")) {
      Object obj = map.get("is_debug");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDebug((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDebug(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("apply_status")) {
      Object obj = map.get("apply_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_msg")) {
      Object obj = map.get("apply_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("login_id")) {
      Object obj = map.get("login_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoginId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("error_code")) {
      Object obj = map.get("error_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_timeout_status")) {
      Object obj = map.get("invoice_timeout_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTimeoutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_timeout_time")) {
      Object obj = map.get("invoice_timeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTimeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceTimeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTimeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTimeoutTime(null);
      }
    }
    if(map.containsKey("request_serial_no")) {
      Object obj = map.get("request_serial_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_request_url")) {
      Object obj = map.get("original_request_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalRequestUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("third_party_platform_no")) {
      Object obj = map.get("third_party_platform_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdPartyPlatformNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("call_back_status")) {
      Object obj = map.get("call_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCallBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("call_back_message")) {
      Object obj = map.get("call_back_message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCallBackMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("call_back_time")) {
      Object obj = map.get("call_back_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCallBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCallBackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCallBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCallBackTime(null);
      }
    }
    if(map.containsKey("customer_request_serial_no")) {
      Object obj = map.get("customer_request_serial_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerRequestSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_status")) {
      Object obj = map.get("bill_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandCode")) {
      Object obj = map.get("brandCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrandCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_code")) {
      Object obj = map.get("platform_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trigger_status")) {
      Object obj = map.get("trigger_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTriggerStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_tid")) {
      Object obj = map.get("platform_tid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformTid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("is_debug")) {
      Object obj = map.get("is_debug");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsDebug((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsDebug(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("apply_status")) {
      Object obj = map.get("apply_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_msg")) {
      Object obj = map.get("apply_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcErpChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("login_id")) {
      Object obj = map.get("login_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLoginId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("error_code")) {
      Object obj = map.get("error_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_timeout_status")) {
      Object obj = map.get("invoice_timeout_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTimeoutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_timeout_time")) {
      Object obj = map.get("invoice_timeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceTimeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceTimeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTimeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceTimeoutTime(null);
      }
    }
    if(map.containsKey("request_serial_no")) {
      Object obj = map.get("request_serial_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_request_url")) {
      Object obj = map.get("original_request_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalRequestUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("third_party_platform_no")) {
      Object obj = map.get("third_party_platform_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdPartyPlatformNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("call_back_status")) {
      Object obj = map.get("call_back_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCallBackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("call_back_message")) {
      Object obj = map.get("call_back_message");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCallBackMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("call_back_time")) {
      Object obj = map.get("call_back_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCallBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCallBackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCallBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCallBackTime(null);
      }
    }
    if(map.containsKey("customer_request_serial_no")) {
      Object obj = map.get("customer_request_serial_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerRequestSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_status")) {
      Object obj = map.get("bill_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brandCode")) {
      Object obj = map.get("brandCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrandCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
