package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-02
 */
public enum ApplyHandleStatus {

    _0("0", "申请中"),
    _1("1", "开票完成"),
    _2("2", "发送失败"),
    _3("3", "发送成功"),
    _4("4", "自动开票失败"),
    _5("5", "部分开票成功（拆票）"),
    _6("6", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyHandleStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
