package com.xforceplus.ultraman.app.aliqianniu.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-04-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChannelConfig implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * erp渠道
   */
  private String ecErpChannel;

  /**
   * 支持电商范围
   */
  private String ecCodeRange;

  /**
   * 渠道类型
   */
  private String channelType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 渠道id
   */
  private Long channelTenantId;

  /**
   * 业务单类型
   */
  private String bizOrderCategory;

  /**
   * 产品包代码
   */
  private String productCode;

  /**
   * 购买链接
   */
  private String buyUrl;

  /**
   * 卡片开关
   */
  private Boolean cardSwitch;

  /**
   * 计费开关
   */
  private Boolean feeSwitch;

  /**
   * 开票超时预警开关
   */
  private Boolean invoiceTimeoutAlertSwitch;

  /**
   * 开票超时天数
   */
  private Long invoiceTimeoutDays;

  /**
   * 开票超时预警天数
   */
  private Long invoiceTimeoutAlertDays;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ec_erp_channel", ecErpChannel);
      map.put("ec_code_range", ecCodeRange);
      map.put("channel_type", channelType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("channel_tenant_id", channelTenantId);
      map.put("biz_order_category", bizOrderCategory);
      map.put("product_code", productCode);
      map.put("buy_url", buyUrl);
      map.put("card_switch", cardSwitch);
      map.put("fee_switch", feeSwitch);
      map.put("invoice_timeout_alert_switch", invoiceTimeoutAlertSwitch);
      map.put("invoice_timeout_days", invoiceTimeoutDays);
      map.put("invoice_timeout_alert_days", invoiceTimeoutAlertDays);

      return map;
  }

  public static ChannelConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChannelConfig entity = new ChannelConfig();
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_code_range")) {
      Object obj = map.get("ec_code_range");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcCodeRange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel_type")) {
      Object obj = map.get("channel_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel_tenant_id")) {
      Object obj = map.get("channel_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChannelTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChannelTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannelTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_category")) {
      Object obj = map.get("biz_order_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buy_url")) {
      Object obj = map.get("buy_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_switch")) {
      Object obj = map.get("card_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCardSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCardSwitch(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("fee_switch")) {
      Object obj = map.get("fee_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFeeSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFeeSwitch(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_timeout_alert_switch")) {
      Object obj = map.get("invoice_timeout_alert_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setInvoiceTimeoutAlertSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTimeoutAlertSwitch(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_timeout_days")) {
      Object obj = map.get("invoice_timeout_days");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTimeoutDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTimeoutDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTimeoutDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_timeout_alert_days")) {
      Object obj = map.get("invoice_timeout_alert_days");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTimeoutAlertDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTimeoutAlertDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTimeoutAlertDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcErpChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_code_range")) {
      Object obj = map.get("ec_code_range");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcCodeRange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel_type")) {
      Object obj = map.get("channel_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannelType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel_tenant_id")) {
      Object obj = map.get("channel_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChannelTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChannelTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setChannelTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_category")) {
      Object obj = map.get("biz_order_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buy_url")) {
      Object obj = map.get("buy_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_switch")) {
      Object obj = map.get("card_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setCardSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCardSwitch(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("fee_switch")) {
      Object obj = map.get("fee_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setFeeSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFeeSwitch(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_timeout_alert_switch")) {
      Object obj = map.get("invoice_timeout_alert_switch");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setInvoiceTimeoutAlertSwitch((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTimeoutAlertSwitch(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_timeout_days")) {
      Object obj = map.get("invoice_timeout_days");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceTimeoutDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTimeoutDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTimeoutDays(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_timeout_alert_days")) {
      Object obj = map.get("invoice_timeout_alert_days");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceTimeoutAlertDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTimeoutAlertDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTimeoutAlertDays(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
