package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ali_apply_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum AliApplyStatus {

    _0("0", "已拒绝"),
    _1("1", "申请中"),
    _2("2", "已同意"),
    _9("9", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AliApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AliApplyStatus fromCode(String code) {
        return Stream.of(AliApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
