package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_error_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum ApplyErrorCode {

    _999("999", "通用错误"),
    _510("510", "服务已到期或用量不足");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyErrorCode fromCode(String code) {
        return Stream.of(ApplyErrorCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
