package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * message_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum MessageType {

    _1("1", "申请对接电商平台"),
    _2("2", "申请对接电商ERP");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MessageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageType fromCode(String code) {
        return Stream.of(MessageType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
