package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * open_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum OpenStatus {

    _0("0", "未开通"),
    _1("1", "已开通");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OpenStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OpenStatus fromCode(String code) {
        return Stream.of(OpenStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
