package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * request_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum RequestType {

    API("API", "API"),
    MESSAGE("MESSAGE", "消息");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RequestType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RequestType fromCode(String code) {
        return Stream.of(RequestType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
