package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rpa_order_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum RpaOrderStatus {

    _0("0", "全部"),
    _1("1", "待发货"),
    _2("2", "已发货"),
    _3("3", "未收货"),
    _4("4", "已收货"),
    _5("5", "已完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RpaOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaOrderStatus fromCode(String code) {
        return Stream.of(RpaOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
