package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rpa_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum RpaStatus {

    _0("0", "停用"),
    _1("1", "正常"),
    _2("2", "断开");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RpaStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaStatus fromCode(String code) {
        return Stream.of(RpaStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
