package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * upload_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-17
 */
public enum UploadStatus {

    _0("0", "回传中"),
    _1("1", "回传成功"),
    _2("2", "回传失败"),
    _3("3", "未回传"),
    _4("4", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    UploadStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadStatus fromCode(String code) {
        return Stream.of(UploadStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
