package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auto_retry_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-20
 */
public enum AutoRetryStatus {

    _1("1", "正常"),
    _2("2", "完成"),
    _9("9", "终止"),
    _3("3", "执行中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoRetryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoRetryStatus fromCode(String code) {
        return Stream.of(AutoRetryStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
