package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auto_retry_task_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-20
 */
public enum AutoRetryTaskType {

    _1("1", "外卖申请开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoRetryTaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoRetryTaskType fromCode(String code) {
        return Stream.of(AutoRetryTaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
