package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_detail_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-20
 */
public enum InvoiceDetailType {

    ITEM_CATEGORY("itemCategory", "按税编类别开具"),
    ITEM_DETAIL("itemDetail", "按商品名称开具");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceDetailType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceDetailType fromCode(String code) {
        return Stream.of(InvoiceDetailType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
