package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * push_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-20
 */
public enum PushHandleStatus {

    _0("0", "待处理"),
    _1("1", "处理中"),
    _2("2", "处理失败"),
    _3("3", "处理成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PushHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PushHandleStatus fromCode(String code) {
        return Stream.of(PushHandleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
