package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum ApplyHandleStatus {

    _0("0", "申请中"),
    _1("1", "开票完成"),
    _2("2", "发送失败"),
    _3("3", "发送成功"),
    _4("4", "自动开票失败"),
    _5("5", "部分开票成功（拆票）"),
    _6("6", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyHandleStatus fromCode(String code) {
        return Stream.of(ApplyHandleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
