package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum AuthStatus {

    _1("1", "已授权"),
    _2("2", "解除授权"),
    _3("3", "授权过期"),
    _4("4", "关闭授权");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatus fromCode(String code) {
        return Stream.of(AuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
