package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * channel_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum ChannelType {

    ALI("ali", "阿里"),
    PDP("pdp", "商联"),
    COMMON("common", "通用"),
    YOUZAN("youzan", "有赞"),
    RPA("rpa", "RPA"),
    MEITUAN("meituan", "美团"),
    ELEME("eleme", "饿了么");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChannelType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChannelType fromCode(String code) {
        return Stream.of(ChannelType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
