package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_kind
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum InvoiceKind {

    _0("0", "电子普票"),
    _1("1", "纸质普票"),
    _2("2", "纸质专票"),
    _3("3", "电子专票"),
    _4("4", "全电普通发票"),
    _5("5", "全电专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind fromCode(String code) {
        return Stream.of(InvoiceKind.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
