package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * source_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum SourceType {

    SK("sk", "税控"),
    QD("qd", "全电");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SourceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceType fromCode(String code) {
        return Stream.of(SourceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
