package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * store_tax_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum StoreTaxStatus {

    _1("1", "正常"),
    _0("0", "未完成"),
    _4("4", "停用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StoreTaxStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreTaxStatus fromCode(String code) {
        return Stream.of(StoreTaxStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
