package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * y_or_not
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public enum YOrNot {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YOrNot(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YOrNot fromCode(String code) {
        return Stream.of(YOrNot.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
