package com.xforceplus.ultraman.app.aliqianniu.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * channel_info
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChannelInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 电商代码
   */
  private String ecCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * erp渠道
   */
  private String ecErpChannel;
  /**
   * 商家租户code
   */
  private String userTenantCode;
  /**
   * 税号
   */
  private String taxNo;
  /**
   * 商家租户id
   */
  private Long userTenantId;
  /**
   * 渠道状态
   */
  private String channelStatus;
  /**
   * 渠道账号
   */
  private String channelAccount;
  /**
   * 商家用户id
   */
  private Long userId;
  /**
   * 运费是否开具
   */
  private String isPostInvoice;
  /**
   * 采集订单状态
   */
  private String rpaOrderStatus;
  /**
   * 是否自动开票
   */
  private Boolean isAutoInvoicing;
  /**
   * 延迟开票天数
   */
  private Long delayInvoicingDays;
  /**
   * 自动开票最小含税额
   */
  private BigDecimal autoInvoicingMinAmount;
  /**
   * 自动开票最大含税额
   */
  private BigDecimal autoInvoicingMaxAmount;
  /**
   * 自动开票商品名称
   */
  private String autoInvoicingItemName;
  /**
   * 自动开票发票类型
   */
  private String autoInvoicingInvoiceType;
  /**
   * 自动开票发票抬头
   */
  private String autoInvoicingInvoiceTitleType;
  /**
   * 自动开票订单状态
   */
  private String autoInvoicingBillStatus;
  /**
   * 组织树
   */
  private String orgTree;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ec_code", ecCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ec_erp_channel", ecErpChannel);
      map.put("user_tenant_code", userTenantCode);
      map.put("tax_no", taxNo);
      map.put("user_tenant_id", userTenantId);
      map.put("channel_status", channelStatus);
      map.put("channel_account", channelAccount);
      map.put("user_id", userId);
      map.put("is_post_invoice", isPostInvoice);
      map.put("rpa_order_status", rpaOrderStatus);
      map.put("is_auto_invoicing", isAutoInvoicing);
      map.put("delay_invoicing_days", delayInvoicingDays);
      map.put("auto_invoicing_min_amount", autoInvoicingMinAmount);
      map.put("auto_invoicing_max_amount", autoInvoicingMaxAmount);
      map.put("auto_invoicing_item_name", autoInvoicingItemName);
      map.put("auto_invoicing_invoice_type", autoInvoicingInvoiceType);
      map.put("auto_invoicing_invoice_title_type", autoInvoicingInvoiceTitleType);
      map.put("auto_invoicing_bill_status", autoInvoicingBillStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static ChannelInfo fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChannelInfo entity = new ChannelInfo();

    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_code")) {
      Object obj = map.get("user_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_id")) {
      Object obj = map.get("user_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("channel_status")) {
      Object obj = map.get("channel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel_account")) {
      Object obj = map.get("channel_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_post_invoice")) {
      Object obj = map.get("is_post_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPostInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rpa_order_status")) {
      Object obj = map.get("rpa_order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRpaOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_auto_invoicing")) {
      Object obj = map.get("is_auto_invoicing");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsAutoInvoicing((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsAutoInvoicing(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("delay_invoicing_days")) {
      Object obj = map.get("delay_invoicing_days");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDelayInvoicingDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDelayInvoicingDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDelayInvoicingDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_min_amount")) {
      Object obj = map.get("auto_invoicing_min_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAutoInvoicingMinAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAutoInvoicingMinAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAutoInvoicingMinAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAutoInvoicingMinAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAutoInvoicingMinAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_max_amount")) {
      Object obj = map.get("auto_invoicing_max_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAutoInvoicingMaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAutoInvoicingMaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAutoInvoicingMaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAutoInvoicingMaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAutoInvoicingMaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_item_name")) {
      Object obj = map.get("auto_invoicing_item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoInvoicingItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_invoice_type")) {
      Object obj = map.get("auto_invoicing_invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoInvoicingInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_invoice_title_type")) {
      Object obj = map.get("auto_invoicing_invoice_title_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoInvoicingInvoiceTitleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_bill_status")) {
      Object obj = map.get("auto_invoicing_bill_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoInvoicingBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_code")) {
      Object obj = map.get("user_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_id")) {
      Object obj = map.get("user_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("channel_status")) {
      Object obj = map.get("channel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannelStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel_account")) {
      Object obj = map.get("channel_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannelAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_post_invoice")) {
      Object obj = map.get("is_post_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsPostInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rpa_order_status")) {
      Object obj = map.get("rpa_order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRpaOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_auto_invoicing")) {
      Object obj = map.get("is_auto_invoicing");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsAutoInvoicing((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsAutoInvoicing(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("delay_invoicing_days")) {
      Object obj = map.get("delay_invoicing_days");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDelayInvoicingDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDelayInvoicingDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDelayInvoicingDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_min_amount")) {
      Object obj = map.get("auto_invoicing_min_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAutoInvoicingMinAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAutoInvoicingMinAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAutoInvoicingMinAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAutoInvoicingMinAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAutoInvoicingMinAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_max_amount")) {
      Object obj = map.get("auto_invoicing_max_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAutoInvoicingMaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAutoInvoicingMaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAutoInvoicingMaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAutoInvoicingMaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAutoInvoicingMaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_item_name")) {
      Object obj = map.get("auto_invoicing_item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoInvoicingItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_invoice_type")) {
      Object obj = map.get("auto_invoicing_invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoInvoicingInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_invoice_title_type")) {
      Object obj = map.get("auto_invoicing_invoice_title_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoInvoicingInvoiceTitleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_invoicing_bill_status")) {
      Object obj = map.get("auto_invoicing_bill_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoInvoicingBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  }
}
