package com.xforceplus.ultraman.app.aliqianniu.metadata.validator;

import com.xforceplus.ultraman.app.aliqianniu.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.aliqianniu.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(BizType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderCycle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderCycle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderCycle.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(TriggerStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TriggerStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TriggerStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(ColorType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ColorType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ColorType.class.getSimpleName());
            }
        }
        if(clazz.equals(RowType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RowType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RowType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TenantProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TenantProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TenantProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AliApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AliApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AliApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PushHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PushHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PushHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(SourceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SourceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EcCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EcCode.class.getSimpleName());
            }
        }
        if(clazz.equals(EcErpChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EcErpChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EcErpChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChannelStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChannelStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StoreStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StoreStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PdpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PdpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PdpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChannelType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChannelType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemTypeCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RpaStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RpaStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceDetailType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceDetailType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceDetailType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsPostInvoice.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsPostInvoice.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsPostInvoice.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyErrorCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyErrorCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RpaOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RpaOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(XmlFileStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != XmlFileStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, XmlFileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTimeoutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTimeoutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTimeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelPaymentMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChannelPaymentMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChannelPaymentMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReverseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RequestType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RequestType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RequestType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMergeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillMergeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillMergeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChannelMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChannelMode.class.getSimpleName());
            }
        }
        if(clazz.equals(CombinationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CombinationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CombinationType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceResultCallbackType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceResultCallbackType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceResultCallbackType.class.getSimpleName());
            }
        }
        if(clazz.equals(CallBackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CallBackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CallBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReleaseType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReleaseType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReleaseType.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoRetryTaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoRetryTaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoRetryTaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoRetryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoRetryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoRetryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreTaxStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StoreTaxStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StoreTaxStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RegisterStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RegisterStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RegisterStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OpenStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OpenStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OpenStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
