package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum BusinessType {

    _0("0", "个人"),
    _1("1", "企业");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessType fromCode(String code) {
        return Stream.of(BusinessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
