package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * channel_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum ChannelStatus {

    _0("0", "未生效"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChannelStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChannelStatus fromCode(String code) {
        return Stream.of(ChannelStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
