package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_cycle
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum OrderCycle {

    _1("1", "年"),
    _2("2", "月"),
    _3("3", "天");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderCycle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderCycle fromCode(String code) {
        return Stream.of(OrderCycle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
