package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * register_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum RegisterStatus {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RegisterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RegisterStatus fromCode(String code) {
        return Stream.of(RegisterStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
