package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * store_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum StoreStatus {

    _0("0", "未完成"),
    _1("1", "正常"),
    _2("2", "计费成功"),
    _3("3", "角色绑定成功"),
    _4("4", "已停用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StoreStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreStatus fromCode(String code) {
        return Stream.of(StoreStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
