package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * xml_file_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public enum XmlFileStatus {

    _0("0", "无需上传"),
    _1("1", "待上传"),
    _2("2", "已上传"),
    _3("3", "上传失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    XmlFileStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static XmlFileStatus fromCode(String code) {
        return Stream.of(XmlFileStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
