package com.xforceplus.ultraman.app.aliqianniu.metadata.validator;

import com.xforceplus.ultraman.app.aliqianniu.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.aliqianniu.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-10-22
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(BizType.class)) {
            isValid = null != BizType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderCycle.class)) {
            isValid = null != OrderCycle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderCycle.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = null != OrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = null != PayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = null != BusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(TriggerStatus.class)) {
            isValid = null != TriggerStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TriggerStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YOrNot.class)) {
            isValid = null != YOrNot.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = null != ApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(ColorType.class)) {
            isValid = null != ColorType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ColorType.class.getSimpleName());
            }
        }
        if(clazz.equals(RowType.class)) {
            isValid = null != RowType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RowType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyHandleStatus.class)) {
            isValid = null != ApplyHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = null != UploadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TenantProcessStatus.class)) {
            isValid = null != TenantProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TenantProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AliApplyStatus.class)) {
            isValid = null != AliApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AliApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PushHandleStatus.class)) {
            isValid = null != PushHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PushHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(SourceType.class)) {
            isValid = null != SourceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcCode.class)) {
            isValid = null != EcCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EcCode.class.getSimpleName());
            }
        }
        if(clazz.equals(EcErpChannel.class)) {
            isValid = null != EcErpChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EcErpChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelStatus.class)) {
            isValid = null != ChannelStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChannelStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreStatus.class)) {
            isValid = null != StoreStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StoreStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PdpStatus.class)) {
            isValid = null != PdpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PdpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelType.class)) {
            isValid = null != ChannelType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChannelType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = null != ItemTypeCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaStatus.class)) {
            isValid = null != RpaStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RpaStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceDetailType.class)) {
            isValid = null != InvoiceDetailType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceDetailType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsPostInvoice.class)) {
            isValid = null != IsPostInvoice.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsPostInvoice.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyErrorCode.class)) {
            isValid = null != ApplyErrorCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaOrderStatus.class)) {
            isValid = null != RpaOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RpaOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(XmlFileStatus.class)) {
            isValid = null != XmlFileStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, XmlFileStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTimeoutStatus.class)) {
            isValid = null != InvoiceTimeoutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTimeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelPaymentMethod.class)) {
            isValid = null != ChannelPaymentMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChannelPaymentMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = null != ReverseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RequestType.class)) {
            isValid = null != RequestType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RequestType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMergeStatus.class)) {
            isValid = null != BillMergeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillMergeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChannelMode.class)) {
            isValid = null != ChannelMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChannelMode.class.getSimpleName());
            }
        }
        if(clazz.equals(CombinationType.class)) {
            isValid = null != CombinationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CombinationType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceResultCallbackType.class)) {
            isValid = null != InvoiceResultCallbackType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceResultCallbackType.class.getSimpleName());
            }
        }
        if(clazz.equals(CallBackStatus.class)) {
            isValid = null != CallBackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CallBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReleaseType.class)) {
            isValid = null != ReleaseType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReleaseType.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoRetryTaskType.class)) {
            isValid = null != AutoRetryTaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoRetryTaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoRetryStatus.class)) {
            isValid = null != AutoRetryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoRetryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StoreTaxStatus.class)) {
            isValid = null != StoreTaxStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StoreTaxStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RegisterStatus.class)) {
            isValid = null != RegisterStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RegisterStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OpenStatus.class)) {
            isValid = null != OpenStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OpenStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
