package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum BizType {

    _1("1", "新订"),
    _2("2", "续订"),
    _3("3", "升级"),
    _4("4", "后台赠送"),
    _5("5", "后台自动续订"),
    _6("6", "解绑复制-0元单"),
    _7("7", "解绑复制-付费单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizType fromCode(String code) {
        return Stream.of(BizType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
