package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * channel_mode
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum ChannelMode {

    _1("1", "渠道模式"),
    _2("2", "中心租户模式"),
    _3("3", "4.0渠道模式");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChannelMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChannelMode fromCode(String code) {
        return Stream.of(ChannelMode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
