package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum EcCode {

    ALI("ALI", "阿里千牛"),
    PDD("PDD", "拼多多"),
    YUXIAOER("YUXIAOER", "寓小二"),
    YOUZAN("YOUZAN", "有赞"),
    DOUYIN("DOUYIN", "抖音"),
    JD("JD", "京东"),
    XHS("XHS", "小红书"),
    COMMON("COMMON", "通用"),
    MEITUAN("MEITUAN", "美团"),
    ELEME("ELEME", "饿了么"),
    TMYP("TMYP", "天猫优品"),
    QMAI("QMAI", "企迈");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EcCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcCode fromCode(String code) {
        return Stream.of(EcCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
