package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_erp_channel
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum EcErpChannel {

    SLPDD("SLPDD", "采集-拼多多"),
    QNSELLER001("qnseller001", "isv-阿里千牛"),
    YUXIAOER("yuxiaoer", "寓小二"),
    PDDRPA("PDDRPA", "RPA-拼多多"),
    YOUZAN("YOUZAN", "isv-有赞"),
    DOUYINRPA("DOUYINRPA", "RPA-抖音"),
    JDRPA("JDRPA", "RPA-京东"),
    XHSRPA("XHSRPA", "RPA-小红书"),
    CHUANGHUO("CHUANGHUO", "闯货"),
    LIAN("LIAN", "连连"),
    MEITUANWAIMAI("MEITUANWAIMAI", "外卖-美团"),
    ELEMEWAIMAI("ELEMEWAIMAI", "外卖-饿了么"),
    QUECTEL("QUECTEL", "移远通信"),
    COOPCLASS("COOPCLASS", "协同渠道测试"),
    TMYP("TMYP", "天猫优品"),
    QMAIXIAOCHENGXU("QMAIXIAOCHENGXU", "小程序-企迈"),
    JDWAIMAI("JDWAIMAI", "外卖-京东");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EcErpChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcErpChannel fromCode(String code) {
        return Stream.of(EcErpChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
