package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_timeout_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum InvoiceTimeoutStatus {

    _0("0", "未超期"),
    _5("5", "已超期"),
    _9("9", "即将超期"),
    _2("2", "已完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceTimeoutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTimeoutStatus fromCode(String code) {
        return Stream.of(InvoiceTimeoutStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
