package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * item_type_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum ItemTypeCode {

    _00("00", "默认"),
    CPY("CPY", "成品油"),
    _02("02", "稀土"),
    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务"),
    _07("07", "代收车船税"),
    _09("09", "旅客运输服务"),
    _10("10", "医疗服务（住院）"),
    _11("11", "医疗服务（门诊）"),
    _12("12", "自产农产品销售"),
    _13("13", "拖拉机和联合收割机"),
    _14("14", "机动车"),
    _15("15", "二手车"),
    _16("16", "农产品收购"),
    _17("17", "光伏收购"),
    _18("18", "卷烟"),
    _20("20", "专票农产品"),
    _26("26", "金银首饰批发"),
    _27("27", "金银首饰零售");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ItemTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemTypeCode fromCode(String code) {
        return Stream.of(ItemTypeCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
