package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * trigger_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum TriggerStatus {

    BUYER_PAYED("buyer_payed", "买家已付款"),
    SENT_GOODS("sent_goods", "卖家已发货"),
    BUYER_CONFIRM("buyer_confirm", "买家确认收货"),
    REFUND_SELLER_CONFIRM("refund_seller_confirm", "卖家同意退款"),
    INVOICE_SUPPLY("invoice_supply", "买家申请补开发票"),
    INVOICE_CHANGE("invoice_change", "买家申请改抬头"),
    CHANGE_PAPER("change_paper", "电换纸"),
    BUYER_CANCEL("buyer_cancel", "买家取消申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TriggerStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TriggerStatus fromCode(String code) {
        return Stream.of(TriggerStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
