package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auto_open_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum AutoOpenFlag {

    _0("0", "不自动开通"),
    _1("1", "自动开通");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoOpenFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoOpenFlag fromCode(String code) {
        return Stream.of(AutoOpenFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
